/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.python.core.MakeProxies;
import org.python.core.Py;
import org.python.core.PyCompoundCallable;
import org.python.core.PyObject;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyBeanEventProperty
extends PyObject {
    private static Map<String, Class<?>> adapterClasses = Generic.map();
    private static Map<Object, Map<String, WeakReference<Object>>> adapters = new WeakHashMap<Object, Map<String, WeakReference<Object>>>();
    public Method addMethod;
    public String eventName;
    public Class<?> eventClass;
    public String __name__;
    private Field adapterField;
    private Class<?> adapterClass;

    public PyBeanEventProperty(String string, Class<?> clazz, Method method, Method method2) {
        this.__name__ = method2.getName().intern();
        this.addMethod = method;
        this.eventName = string;
        this.eventClass = clazz;
    }

    @Override
    public PyObject _doget(PyObject pyObject) {
        Object object;
        if (pyObject == null) {
            return this;
        }
        this.initAdapter();
        Object obj = Py.tojava(pyObject, this.addMethod.getDeclaringClass());
        try {
            object = this.adapterField.get(this.getAdapter(obj));
        }
        catch (Exception exception) {
            throw Py.JavaError(exception);
        }
        if (object == null) {
            PyCompoundCallable pyCompoundCallable = new PyCompoundCallable();
            this.setFunction(obj, pyCompoundCallable);
            return pyCompoundCallable;
        }
        if (object instanceof PyCompoundCallable) {
            return (PyCompoundCallable)object;
        }
        PyCompoundCallable pyCompoundCallable = new PyCompoundCallable();
        this.setFunction(obj, pyCompoundCallable);
        pyCompoundCallable.append((PyObject)object);
        return pyCompoundCallable;
    }

    @Override
    public boolean _doset(PyObject pyObject, PyObject pyObject2) {
        Object obj = Py.tojava(pyObject, this.addMethod.getDeclaringClass());
        if (!(pyObject2 instanceof PyCompoundCallable)) {
            PyCompoundCallable pyCompoundCallable = new PyCompoundCallable();
            this.setFunction(obj, pyCompoundCallable);
            pyCompoundCallable.append(pyObject2);
        } else {
            this.setFunction(obj, pyObject2);
        }
        return true;
    }

    @Override
    public String toString() {
        return "<beanEventProperty " + this.__name__ + " for event " + this.eventClass.toString() + " " + Py.idstr(this) + ">";
    }

    private Object getAdapter(Object object, String string) {
        Map<String, WeakReference<Object>> map = adapters.get(object);
        if (map == null) {
            return null;
        }
        WeakReference<Object> weakReference = map.get(string);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    private void putAdapter(Object object, String string, Object object2) {
        Map<String, WeakReference<Object>> map = adapters.get(object);
        if (map == null) {
            map = Generic.map();
            adapters.put(object, map);
        }
        map.put(string, new WeakReference<Object>(object2));
    }

    private synchronized Object getAdapter(Object object) {
        String string = this.eventClass.getName();
        Object object2 = this.getAdapter(object, string);
        if (object2 != null) {
            return object2;
        }
        try {
            object2 = this.adapterClass.newInstance();
            this.addMethod.invoke(object, object2);
        }
        catch (Exception exception) {
            throw Py.JavaError(exception);
        }
        this.putAdapter(object, string, object2);
        return object2;
    }

    private void initAdapter() {
        if (this.adapterClass == null) {
            this.adapterClass = PyBeanEventProperty.getAdapterClass(this.eventClass);
            try {
                this.adapterField = this.adapterClass.getField(this.__name__);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw Py.AttributeError("Internal bean event error: " + this.__name__);
            }
        }
    }

    private void setFunction(Object object, PyObject pyObject) {
        this.initAdapter();
        try {
            this.adapterField.set(this.getAdapter(object), pyObject);
        }
        catch (Exception exception) {
            throw Py.JavaError(exception);
        }
    }

    private static synchronized Class<?> getAdapterClass(Class<?> clazz) {
        String string = "org.python.proxies." + clazz.getName() + "$Adapter";
        Class<?> clazz2 = Py.findClass(string);
        if (clazz2 == null && (clazz2 = adapterClasses.get(string)) == null) {
            clazz2 = MakeProxies.makeAdapter(clazz);
            adapterClasses.put(string, clazz2);
        }
        return clazz2;
    }
}

